/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public abstract class ParsedTerms
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Terms {
    protected long docCountErrorUpperBound;
    protected long sumOtherDocCount;

    @Override
    public long getDocCountError() {
        return this.docCountErrorUpperBound;
    }

    @Override
    public long getSumOfOtherDocCounts() {
        return this.sumOtherDocCount;
    }

    @Override
    public List<? extends Terms.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Terms.Bucket getBucketByKey(String term) {
        for (Terms.Bucket bucket : this.getBuckets()) {
            if (!bucket.getKeyAsString().equals(term)) continue;
            return bucket;
        }
        return null;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
        builder.field(InternalTerms.SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), this.getSumOfOtherDocCounts());
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Terms.Bucket bucket : this.getBuckets()) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static void declareParsedTermsFields(ObjectParser<? extends ParsedTerms, Void> objectParser, CheckedFunction<XContentParser, ParsedBucket, IOException> bucketParser) {
        ParsedTerms.declareMultiBucketAggregationFields(objectParser, bucketParser::apply, bucketParser::apply);
        objectParser.declareLong((parsedTerms, value) -> {
            parsedTerms.docCountErrorUpperBound = value;
        }, InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME);
        objectParser.declareLong((parsedTerms, value) -> {
            parsedTerms.sumOtherDocCount = value;
        }, InternalTerms.SUM_OF_OTHER_DOC_COUNTS);
    }

    public static abstract class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Terms.Bucket {
        boolean showDocCountError = false;
        protected long docCountError;

        @Override
        public int compareTerm(Terms.Bucket other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDocCountError() {
            return this.docCountError;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.showDocCountError) {
                builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        static <B extends ParsedBucket> B parseTermsBucketXContent(XContentParser parser, Supplier<B> bucketSupplier, CheckedBiConsumer<XContentParser, B, IOException> keyConsumer) throws IOException {
            XContentParser.Token token;
            ParsedBucket bucket = (ParsedBucket)bucketSupplier.get();
            ArrayList aggregations = new ArrayList();
            String currentFieldName = parser.currentName();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        keyConsumer.accept(parser, bucket);
                        continue;
                    }
                    if (Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) {
                        bucket.setDocCount(parser.longValue());
                        continue;
                    }
                    if (!InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName().equals(currentFieldName)) continue;
                    bucket.docCountError = parser.longValue();
                    bucket.showDocCountError = true;
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return (B)bucket;
        }
    }
}

