/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.match;

import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.algorithm.match.SimilarityMeasure;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;

public class HausdorffSimilarityMeasure
implements SimilarityMeasure {
    private static final double DENSIFY_FRACTION = 0.25;

    public double measure(Geometry g1, Geometry g2) {
        double distance = DiscreteHausdorffDistance.distance(g1, g2, 0.25);
        Envelope env = new Envelope(g1.getEnvelopeInternal());
        env.expandToInclude(g2.getEnvelopeInternal());
        double envSize = HausdorffSimilarityMeasure.diagonalSize(env);
        double measure = 1.0 - distance / envSize;
        return measure;
    }

    public static double diagonalSize(Envelope env) {
        if (env.isNull()) {
            return 0.0;
        }
        double width = env.getWidth();
        double hgt = env.getHeight();
        return Math.sqrt(width * width + hgt * hgt);
    }
}

