/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.harvester.OAIMetadataDocument;
import de.pangaea.metadataportal.utils.SaxRule;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class OAIMetadataSaxRule
extends SaxRule {
    private OAIMetadataDocument doc = null;
    private boolean enabled = true;
    private static final Set<String> EXCLUDE_NS = Set.of("http://www.openarchives.org/OAI/2.0/", "http://www.openarchives.org/OAI/2.0/static-repository");

    public OAIMetadataSaxRule() {
        this.setExcludeNamespaces(EXCLUDE_NS);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.enabled) {
            this.doc = (OAIMetadataDocument)this.digester.peek();
            ContentHandler handler = this.doc.getConverter().getTransformContentHandler();
            this.setContentHandler(handler);
        } else {
            this.doc = null;
            this.setContentHandler(new DefaultHandler());
        }
        super.begin(namespace, name, attributes);
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        super.end(namespace, name);
        if (this.enabled) {
            this.doc.getConverter().finishTransformation();
            this.doc = null;
        }
    }
}

