/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.OAIException;
import de.pangaea.metadataportal.harvester.OAIHarvesterBase;
import de.pangaea.metadataportal.harvester.OAIMetadataSaxRule;
import de.pangaea.metadataportal.utils.ExtendedDigester;
import de.pangaea.metadataportal.utils.ISODateFormatter;
import de.pangaea.metadataportal.utils.PublicForDigesterUse;
import de.pangaea.metadataportal.utils.SaxRule;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rules;

public class OAIHarvester
extends OAIHarvesterBase {
    private static final String[] requestVariables = new String[]{"verb", "identifier", "metadataPrefix", "from", "until", "set", "resumptionToken"};
    private ExtendedDigester listRecordsDig = null;
    private ExtendedDigester identifyDig = null;
    private String currResumptionToken = null;
    private Duration currResumptionExpiration = null;
    private Instant currResponseDate = null;
    private boolean fineGranularity = false;

    public OAIHarvester(HarvesterConfig iconfig) {
        super(iconfig);
        this.filterIncomingSets = this.sets != null && this.sets.size() > 1;
    }

    @Override
    protected void recreateDigester() {
        this.listRecordsDig = new ExtendedDigester();
        this.digesterAddGeneralOAIRules(this.listRecordsDig);
        this.listRecordsDig.addDoNothing("OAI-PMH/ListRecords");
        this.listRecordsDig.addFactoryCreate("OAI-PMH/ListRecords/record", this.getMetadataDocumentFactory());
        this.listRecordsDig.addSetNext("OAI-PMH/ListRecords/record", "addDocument");
        this.listRecordsDig.addCallMethod("OAI-PMH/ListRecords/record/header", "setHeaderInfo", 3);
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/record/header", 0, "status");
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/record/header/identifier", 1);
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/record/header/datestamp", 2);
        this.listRecordsDig.addCallMethod("OAI-PMH/ListRecords/record/header/setSpec", "addSet", 0);
        this.listRecordsDig.addRule("OAI-PMH/ListRecords/record/metadata", new OAIMetadataSaxRule());
        this.listRecordsDig.addRule("OAI-PMH/ListRecords/record/about", SaxRule.emptyRule());
        this.listRecordsDig.addCallMethod("OAI-PMH/ListRecords/resumptionToken", "setResumptionToken", 4);
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/resumptionToken", 0);
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/resumptionToken", 1, "expirationDate");
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/resumptionToken", 2, "cursor");
        this.listRecordsDig.addCallParam("OAI-PMH/ListRecords/resumptionToken", 3, "completeListSize");
        this.identifyDig = new ExtendedDigester();
        this.digesterAddGeneralOAIRules(this.identifyDig);
        this.identifyDig.addDoNothing("OAI-PMH/Identify");
        this.identifyDig.addCallMethod("OAI-PMH/Identify/granularity", "setGranularity", 0);
        this.identifyDig.addRule("OAI-PMH/Identify/description", SaxRule.emptyRule());
        this.identifyDig.addDoNothing("OAI-PMH/Identify/*");
    }

    private void digesterAddGeneralOAIRules(ExtendedDigester dig) {
        dig.setEntityResolver(this.getEntityResolver(dig.getEntityResolver()));
        dig.setNamespaceAware(true);
        dig.setValidating(false);
        dig.setXIncludeAware(false);
        dig.setRulesWithInvalidElementCheck((Rules)new ExtendedBaseRules());
        dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/");
        dig.addDoNothing("OAI-PMH");
        dig.addCallMethod("OAI-PMH/responseDate", "setResponseDate", 0);
        dig.addObjectCreate("OAI-PMH/request", HashMap.class);
        dig.addSetNext("OAI-PMH/request", "setRequest");
        for (String v : requestVariables) {
            dig.addCallMethod("OAI-PMH/request", "put", 2);
            dig.addObjectParam("OAI-PMH/request", 0, v);
            dig.addCallParam("OAI-PMH/request", 1, v);
        }
        dig.addCallMethod("OAI-PMH/request", "put", 2);
        dig.addObjectParam("OAI-PMH/request", 0, "url");
        dig.addCallParam("OAI-PMH/request", 1);
        dig.addCallMethod("OAI-PMH/error", "doError", 2);
        dig.addCallParam("OAI-PMH/error", 0, "code");
        dig.addCallParam("OAI-PMH/error", 1);
    }

    @PublicForDigesterUse
    @Deprecated
    public void setGranularity(String granularity) {
        if ("YYYY-MM-DD".equals(granularity)) {
            this.fineGranularity = false;
        } else if ("YYYY-MM-DDThh:mm:ssZ".equals(granularity)) {
            this.fineGranularity = true;
        } else {
            throw new IllegalArgumentException("Invalid granularity in identify response: " + granularity);
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setResumptionToken(String token, String expirationDateStr, String cursorStr, String completeListSizeStr) {
        if (token != null && token.equals("")) {
            token = null;
        }
        this.currResumptionToken = token;
        if (expirationDateStr != null && this.currResponseDate != null) {
            try {
                this.currResumptionExpiration = Duration.between(this.currResponseDate, ISODateFormatter.parseOAIDate(expirationDateStr));
                if (this.currResumptionExpiration.isNegative()) {
                    this.currResumptionExpiration = null;
                }
            }
            catch (Exception e) {
                this.currResumptionExpiration = null;
            }
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void doError(String code, String message) throws OAIException {
        if (!"noRecordsMatch".equals(code)) {
            throw new OAIException(code, message);
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setResponseDate(String date) {
        try {
            this.currResponseDate = ISODateFormatter.parseOAIDate(date);
        }
        catch (DateTimeParseException pe) {
            if (!this.ignoreDatestamps) {
                throw pe;
            }
            this.log.warn((Object)("Invalid datestamp in OAI response (ignored): " + date));
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setRequest(Map<String, String> req) {
    }

    private void readStream(String url) throws Exception {
        this.log.info((Object)("Harvesting \"" + url + "\"..."));
        this.doParse(() -> this.listRecordsDig, url, null);
    }

    private void checkIdentify(String baseURL) throws Exception {
        StringBuilder url = new StringBuilder(baseURL).append("?verb=Identify");
        this.log.info((Object)("Reading identify response from \"" + String.valueOf(url) + "\"..."));
        this.doParse(() -> this.identifyDig, url.toString(), null);
        this.log.info((Object)("Repository supports " + (this.fineGranularity ? "seconds" : "days") + "-granularity in selective harvesting."));
    }

    @Override
    protected void reset() {
        super.reset();
        this.currResponseDate = null;
        this.currResumptionToken = null;
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        this.listRecordsDig = null;
        this.identifyDig = null;
        super.close(cleanShutdown);
    }

    @Override
    public void harvest() throws Exception {
        String baseUrl = this.iconfig.properties.getProperty("baseUrl");
        if (baseUrl == null) {
            throw new NullPointerException("No baseUrl of the OAI repository was given!");
        }
        this.checkIdentify(baseUrl);
        this.reset();
        StringBuilder url = new StringBuilder(baseUrl).append("?verb=ListRecords&metadataPrefix=").append(URLEncoder.encode(this.metadataPrefix, StandardCharsets.UTF_8.name()));
        if (this.sets != null) {
            if (this.sets.size() == 1) {
                url.append("&set=").append(URLEncoder.encode((String)this.sets.iterator().next(), StandardCharsets.UTF_8.name()));
            } else {
                this.log.warn((Object)"More than one set to be harvested - this is not supported by OAI-PMH. Filtering documents during harvesting!");
            }
        }
        if (this.fromDateReference != null && !this.ignoreDatestamps) {
            String from = ISODateFormatter.formatOAIDate(this.fromDateReference, this.fineGranularity);
            url.append("&from=").append(URLEncoder.encode(from, StandardCharsets.UTF_8.name()));
        } else {
            this.enableMissingDocumentDelete();
        }
        this.readStream(url.toString());
        this.setHarvestingDateReference(this.currResponseDate);
        while (this.currResumptionToken != null) {
            if (this.currResumptionExpiration != null) {
                this.log.debug((Object)("Resumption token expires in " + this.currResumptionExpiration.getSeconds() + "s"));
            }
            url = new StringBuilder(baseUrl).append("?verb=ListRecords&resumptionToken=").append(URLEncoder.encode(this.currResumptionToken, StandardCharsets.UTF_8.name()));
            this.reset();
            this.readStream(url.toString());
        }
        this.reset();
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.add("baseUrl");
    }
}

