/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class MaxAgeCondition
extends Condition<TimeValue> {
    public static final String NAME = "max_age";

    public MaxAgeCondition(TimeValue value) {
        super(NAME);
        this.value = value;
    }

    public MaxAgeCondition(StreamInput in) throws IOException {
        super(NAME);
        this.value = TimeValue.timeValueMillis(in.readLong());
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        long indexAge = System.currentTimeMillis() - stats.indexCreated;
        return new Condition.Result(this, ((TimeValue)this.value).getMillis() <= indexAge);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(((TimeValue)this.value).getMillis());
    }
}

