/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;

public final class ISODateFormatter {
    private static final DateTimeFormatter ELASTIC_DATE_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter LONG_DATE_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter SHORT_DATE_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd", Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter PARSE_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd").optionalStart().appendLiteral('T').appendPattern("HH:mm:ss").appendLiteral('Z').toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT).withZone(ZoneOffset.UTC);

    private ISODateFormatter() {
    }

    public static Instant parseOAIDate(String date) {
        TemporalAccessor temporal = PARSE_DATE_FORMAT.parse(date);
        LocalTime time = temporal.query(TemporalQueries.localTime());
        if (time == null) {
            time = LocalTime.MIDNIGHT;
        }
        return LocalDate.from(temporal).atTime(time).toInstant(ZoneOffset.UTC);
    }

    public static String formatOAIDate(TemporalAccessor date, boolean fineGranularity) {
        return (fineGranularity ? LONG_DATE_FORMAT : SHORT_DATE_FORMAT).format(date);
    }

    public static String formatElasticsearch(TemporalAccessor date) {
        return ELASTIC_DATE_FORMAT.format(date);
    }
}

