/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class MinDocQuery
extends Query {
    private final Object readerId;
    private final int minDoc;

    public MinDocQuery(int minDoc) {
        this(minDoc, null);
    }

    MinDocQuery(int minDoc, Object readerId) {
        this.minDoc = minDoc;
        this.readerId = readerId;
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.minDoc, this.readerId);
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        MinDocQuery that = (MinDocQuery)((Object)obj);
        return this.minDoc == that.minDoc && Objects.equals(this.readerId, that.readerId);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (!Objects.equals(reader.getContext().id(), this.readerId)) {
            return new MinDocQuery(this.minDoc, reader.getContext().id());
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (this.readerId == null) {
            throw new IllegalStateException("Rewrite first");
        }
        if (!Objects.equals(searcher.getIndexReader().getContext().id(), this.readerId)) {
            throw new IllegalStateException("Executing against a different reader than the query has been rewritten against");
        }
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final int maxDoc = context.reader().maxDoc();
                if (context.docBase + maxDoc <= MinDocQuery.this.minDoc) {
                    return null;
                }
                final int segmentMinDoc = Math.max(0, MinDocQuery.this.minDoc - context.docBase);
                DocIdSetIterator disi = new DocIdSetIterator(){
                    int doc = -1;

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    public int advance(int target) throws IOException {
                        assert (target > this.doc);
                        this.doc = this.doc == -1 ? Math.max(target, segmentMinDoc) : target;
                        if (this.doc >= maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                        }
                        return this.doc;
                    }

                    public long cost() {
                        return maxDoc - segmentMinDoc;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    public String toString(String field) {
        return "MinDocQuery(minDoc=" + this.minDoc + ")";
    }
}

