/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.FiniteStringsIterator;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public final class GraphTokenStreamFiniteStrings {
    private final Map<Integer, BytesRef> idToTerm = new HashMap<Integer, BytesRef>();
    private final Map<Integer, Integer> idToInc = new HashMap<Integer, Integer>();
    private final Automaton det;
    private final Transition transition = new Transition();

    public GraphTokenStreamFiniteStrings(TokenStream in) throws IOException {
        Automaton aut = this.build(in);
        this.det = Operations.removeDeadStates(Operations.determinize(aut, 10000));
    }

    public boolean hasSidePath(int state) {
        int numT = this.det.initTransition(state, this.transition);
        if (numT <= 1) {
            return false;
        }
        this.det.getNextTransition(this.transition);
        int dest = this.transition.dest;
        for (int i = 1; i < numT; ++i) {
            this.det.getNextTransition(this.transition);
            if (dest == this.transition.dest) continue;
            return true;
        }
        return false;
    }

    public Term[] getTerms(String field, int state) {
        int numT = this.det.initTransition(state, this.transition);
        ArrayList<Term> terms = new ArrayList<Term>();
        for (int i = 0; i < numT; ++i) {
            this.det.getNextTransition(this.transition);
            for (int id = this.transition.min; id <= this.transition.max; ++id) {
                Term term = new Term(field, this.idToTerm.get(id));
                terms.add(term);
            }
        }
        return terms.toArray(new Term[terms.size()]);
    }

    public Iterator<TokenStream> getFiniteStrings() throws IOException {
        return this.getFiniteStrings(0, -1);
    }

    public Iterator<TokenStream> getFiniteStrings(int startState, int endState) throws IOException {
        final FiniteStringsIterator it = new FiniteStringsIterator(this.det, startState, endState);
        return new Iterator<TokenStream>(){
            IntsRef current;
            boolean finished = false;

            @Override
            public boolean hasNext() {
                if (!this.finished && this.current == null) {
                    this.current = it.next();
                    if (this.current == null) {
                        this.finished = true;
                    }
                }
                return this.current != null;
            }

            @Override
            public TokenStream next() {
                if (this.current == null) {
                    this.hasNext();
                }
                FiniteStringsTokenStream next = new FiniteStringsTokenStream(this.current);
                this.current = null;
                return next;
            }
        };
    }

    public int[] articulationPoints() {
        if (this.det.getNumStates() == 0) {
            return new int[0];
        }
        Automaton.Builder undirect = new Automaton.Builder();
        undirect.copy(this.det);
        for (int i = 0; i < this.det.getNumStates(); ++i) {
            int numT = this.det.initTransition(i, this.transition);
            for (int j = 0; j < numT; ++j) {
                this.det.getNextTransition(this.transition);
                undirect.addTransition(this.transition.dest, i, this.transition.min);
            }
        }
        int numStates = this.det.getNumStates();
        BitSet visited = new BitSet(numStates);
        int[] depth = new int[this.det.getNumStates()];
        int[] low = new int[this.det.getNumStates()];
        int[] parent = new int[this.det.getNumStates()];
        Arrays.fill(parent, -1);
        ArrayList<Integer> points = new ArrayList<Integer>();
        GraphTokenStreamFiniteStrings.articulationPointsRecurse(undirect.finish(), 0, 0, depth, low, parent, visited, points);
        Collections.reverse(points);
        return points.stream().mapToInt(p -> p).toArray();
    }

    private Automaton build(TokenStream in) throws IOException {
        Automaton.Builder builder = new Automaton.Builder();
        TermToBytesRefAttribute termBytesAtt = in.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncAtt = in.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLengthAtt = in.addAttribute(PositionLengthAttribute.class);
        in.reset();
        int pos = -1;
        int prevIncr = 1;
        int state = -1;
        while (in.incrementToken()) {
            int currentIncr = posIncAtt.getPositionIncrement();
            if (pos == -1 && currentIncr < 1) {
                throw new IllegalStateException("Malformed TokenStream, start token can't have increment less than 1");
            }
            int incr = Math.min(1, currentIncr);
            if (incr > 0) {
                pos += incr;
            }
            int endPos = pos + posLengthAtt.getPositionLength();
            while (state < endPos) {
                state = builder.createState();
            }
            BytesRef term = termBytesAtt.getBytesRef();
            int id = this.getTermID(currentIncr, prevIncr, term);
            builder.addTransition(pos, endPos, id);
            if (currentIncr <= 0) continue;
            prevIncr = currentIncr;
        }
        in.end();
        if (state != -1) {
            builder.setAccept(state, true);
        }
        return builder.finish();
    }

    private int getTermID(int incr, int prevIncr, BytesRef term) {
        assert (term != null);
        boolean isStackedGap = incr == 0 && prevIncr > 1;
        int id = this.idToTerm.size();
        this.idToTerm.put(id, BytesRef.deepCopyOf(term));
        if (isStackedGap) {
            this.idToInc.put(id, prevIncr);
        } else if (incr > 1) {
            this.idToInc.put(id, incr);
        }
        return id;
    }

    private static void articulationPointsRecurse(Automaton a, int state, int d, int[] depth, int[] low, int[] parent, BitSet visited, List<Integer> points) {
        visited.set(state);
        depth[state] = d;
        low[state] = d;
        int childCount = 0;
        boolean isArticulation = false;
        Transition t = new Transition();
        int numT = a.initTransition(state, t);
        for (int i = 0; i < numT; ++i) {
            a.getNextTransition(t);
            if (!visited.get(t.dest)) {
                parent[t.dest] = state;
                GraphTokenStreamFiniteStrings.articulationPointsRecurse(a, t.dest, d + 1, depth, low, parent, visited, points);
                ++childCount;
                if (low[t.dest] >= depth[state]) {
                    isArticulation = true;
                }
                low[state] = Math.min(low[state], low[t.dest]);
                continue;
            }
            if (t.dest == parent[state]) continue;
            low[state] = Math.min(low[state], depth[t.dest]);
        }
        if (parent[state] != -1 && isArticulation || parent[state] == -1 && childCount > 1) {
            points.add(state);
        }
    }

    private class FiniteStringsTokenStream
    extends TokenStream {
        private final BytesTermAttribute termAtt = this.addAttribute(BytesTermAttribute.class);
        private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
        private final IntsRef ids;
        private final int end;
        private int offset;

        FiniteStringsTokenStream(IntsRef ids) {
            assert (ids != null);
            this.ids = ids;
            this.offset = ids.offset;
            this.end = ids.offset + ids.length;
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (this.offset < this.end) {
                this.clearAttributes();
                int id = this.ids.ints[this.offset];
                this.termAtt.setBytesRef((BytesRef)GraphTokenStreamFiniteStrings.this.idToTerm.get(id));
                int incr = 1;
                if (GraphTokenStreamFiniteStrings.this.idToInc.containsKey(id)) {
                    incr = (Integer)GraphTokenStreamFiniteStrings.this.idToInc.get(id);
                }
                this.posIncAtt.setPositionIncrement(incr);
                ++this.offset;
                return true;
            }
            return false;
        }
    }
}

