/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.processor.MetadataDocument;
import de.pangaea.metadataportal.utils.ISODateFormatter;
import de.pangaea.metadataportal.utils.PublicForDigesterUse;
import java.time.format.DateTimeParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIMetadataDocument
extends MetadataDocument {
    private static final Log log = LogFactory.getLog(OAIMetadataDocument.class);
    private final String identifierPrefix;
    private final boolean ignoreDatestamps;
    protected Set<String> sets = new LinkedHashSet<String>();

    public OAIMetadataDocument(HarvesterConfig iconfig, String identifierPrefix, boolean ignoreDatestamps) {
        super(iconfig);
        this.identifierPrefix = identifierPrefix;
        this.ignoreDatestamps = ignoreDatestamps;
    }

    @PublicForDigesterUse
    @Deprecated
    public void setHeaderInfo(String status, String identifier, String datestampStr) {
        this.setDeleted(status != null && status.equals("deleted"));
        this.setIdentifier(this.identifierPrefix + identifier);
        try {
            this.setDatestamp(ISODateFormatter.parseOAIDate(datestampStr));
        }
        catch (DateTimeParseException pe) {
            if (this.ignoreDatestamps || this.deleted) {
                log.warn((Object)("Invalid datestamp in OAI response (ignored): " + datestampStr));
            }
            throw pe;
        }
    }

    public void addSet(String set) {
        this.sets.add(set);
    }

    public Set<String> getSets() {
        return this.sets;
    }

    @Override
    public String toString() {
        return super.toString() + " sets=" + String.valueOf(this.sets);
    }
}

