/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HostAndPort {
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");

    private HostAndPort() {
    }

    public static InetSocketAddress parse(String hostPortString, int defaultPort) {
        String portString;
        String host;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.lastIndexOf(58);
            if (colonPos >= 0) {
                host = hostPortString.substring(0, colonPos);
                if (host.indexOf(58) >= 0) {
                    throw new IllegalArgumentException("Multiple colons in host name: " + hostPortString);
                }
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                portString = null;
            }
        }
        int port = defaultPort;
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
        }
        return new InetSocketAddress(host, port);
    }
}

