/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportResponse;

final class ClearScrollController
implements Runnable {
    private final DiscoveryNodes nodes;
    private final SearchTransportService searchTransportService;
    private final CountDown expectedOps;
    private final ActionListener<ClearScrollResponse> listener;
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    private final AtomicInteger freedSearchContexts = new AtomicInteger(0);
    private final Logger logger;
    private final Runnable runner;

    ClearScrollController(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, DiscoveryNodes nodes, Logger logger, SearchTransportService searchTransportService) {
        int expectedOps;
        this.nodes = nodes;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.listener = listener;
        List<String> scrollIds = request.getScrollIds();
        if (scrollIds.size() == 1 && "_all".equals(scrollIds.get(0))) {
            expectedOps = nodes.getSize();
            this.runner = this::cleanAllScrolls;
        } else {
            ArrayList<ScrollIdForNode> parsedScrollIds = new ArrayList<ScrollIdForNode>();
            for (String parsedScrollId : request.getScrollIds()) {
                ScrollIdForNode[] context;
                for (ScrollIdForNode id : context = TransportSearchHelper.parseScrollId(parsedScrollId).getContext()) {
                    parsedScrollIds.add(id);
                }
            }
            if (parsedScrollIds.isEmpty()) {
                expectedOps = 0;
                this.runner = () -> listener.onResponse(new ClearScrollResponse(true, 0));
            } else {
                expectedOps = parsedScrollIds.size();
                this.runner = () -> this.cleanScrollIds(parsedScrollIds);
            }
        }
        this.expectedOps = new CountDown(expectedOps);
    }

    @Override
    public void run() {
        this.runner.run();
    }

    void cleanAllScrolls() {
        for (final DiscoveryNode node : this.nodes) {
            try {
                Transport.Connection connection = this.searchTransportService.getConnection(null, node);
                this.searchTransportService.sendClearAllScrollContexts(connection, new ActionListener<TransportResponse>(){

                    @Override
                    public void onResponse(TransportResponse response) {
                        ClearScrollController.this.onFreedContext(true);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        ClearScrollController.this.onFailedFreedContext(e, node);
                    }
                });
            }
            catch (Exception e) {
                this.onFailedFreedContext(e, node);
            }
        }
    }

    void cleanScrollIds(List<ScrollIdForNode> parsedScrollIds) {
        SearchScrollAsyncAction.collectNodesAndRun(parsedScrollIds, this.nodes, this.searchTransportService, ActionListener.wrap(lookup -> {
            for (ScrollIdForNode target : parsedScrollIds) {
                DiscoveryNode node = (DiscoveryNode)lookup.apply(target.getClusterAlias(), target.getNode());
                if (node == null) {
                    this.onFreedContext(false);
                    continue;
                }
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(target.getClusterAlias(), node);
                    this.searchTransportService.sendFreeContext(connection, target.getScrollId(), ActionListener.wrap(freed -> this.onFreedContext(freed.isFreed()), e -> this.onFailedFreedContext((Throwable)e, node)));
                }
                catch (Exception e2) {
                    this.onFailedFreedContext(e2, node);
                }
            }
        }, this.listener::onFailure));
    }

    private void onFreedContext(boolean freed) {
        if (freed) {
            this.freedSearchContexts.incrementAndGet();
        }
        if (this.expectedOps.countDown()) {
            boolean succeeded = !this.hasFailed.get();
            this.listener.onResponse(new ClearScrollResponse(succeeded, this.freedSearchContexts.get()));
        }
    }

    private void onFailedFreedContext(Throwable e, DiscoveryNode node) {
        this.logger.warn(() -> new ParameterizedMessage("Clear SC failed on node[{}]", (Object)node), e);
        this.hasFailed.set(true);
        if (this.expectedOps.countDown()) {
            this.listener.onResponse(new ClearScrollResponse(false, this.freedSearchContexts.get()));
        }
    }
}

